/**
* \file: request_messages.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMS_IPC_REQUEST_MESSAGES_H
#define AMS_IPC_REQUEST_MESSAGES_H

#include "automounter_types.h"
#include "ipc/message_buffer.h"

typedef void (*request_done_callback_t)(int request_id, error_code_t result, const char *error_msg);

typedef enum identifier_type_t
{
	ID_TYPE_PARTITION_ID,
	ID_TYPE_DEVICE_ID,
	ID_TYPE_MOUNTPOINT
} identifier_type_t;

typedef struct request_remount_message_t
{
	const char *identifier;
	const char *options;
	identifier_type_t id_type;
	int request_id;
	void *callback_func;
} request_remount_message_t;

typedef struct request_umount_message_t
{
	const char *identifier;
	identifier_type_t id_type;
	int request_id;
	void *callback_func;
} request_umount_message_t;

typedef struct request_done_message_t
{
	int request_id;
	void *callback_func;
	error_code_t result;
	const char *error_message;
} request_done_message_t;

typedef struct snapshot_request_message_t
{
	snapshot_scope_t scope;
	int request_id;
} snapshot_request_message_t;

error_code_t request_message_prepare_remount_request_msg(message_buffer_t *msg_buffer,const char *identifier, const char *options,
		const identifier_type_t id_type, const int request_id, void *callback_func);

error_code_t request_message_extract_remount_request_msg(message_buffer_t *msg_buffer, request_remount_message_t **msg_ptr);

error_code_t request_message_prepare_umount_request_msg(message_buffer_t *msg_buffer, const char *identifier,
		const identifier_type_t id_type, const int request_id, void *callback_func);

error_code_t request_message_extract_umount_request_msg(message_buffer_t *msg_buffer,
		request_umount_message_t **msg_ptr);

error_code_t request_message_prepare_request_done_msg(message_buffer_t *msg_buffer, error_code_t result,
		const char *error_msg, const int request_id, void *callback_func);

error_code_t request_message_extract_request_done_msg(message_buffer_t *msg_buffer,
		request_done_message_t **msg_ptr);

error_code_t request_message_prepare_snapshot_request_msg(message_buffer_t *msg_buffer, snapshot_scope_t scope,
		int request_id);

error_code_t request_message_extract_snapshot_request_msg(message_buffer_t *msg_buffer,
		snapshot_request_message_t **msg_ptr);

error_code_t request_message_prepare_snapshot_done_msg(message_buffer_t *msg_buffer, int request_id);

error_code_t request_message_extract_snapshot_done_msg(message_buffer_t *msg_buffer,
		int **request_id_ptr);

#endif
